//
//  TTTEncryptionTransformer.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/24/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTEncryptionTransformer.h"
#import "NSData+TTTCrypto.h"
#define TTTENCRYPTIONKEY "TTTC0D3"

@implementation TTTEncryptionTransformer


    + (Class)transformedValueClass{
        return [NSString class]; // returns a string
    }

    + (BOOL)allowsReverseTransformation{
        return YES;
    }

    - (id)transformedValue:(id)sourceValue{
        id retVal=nil;
        if (sourceValue != nil){
            NSData *UTFEncodedSourceValue = [sourceValue dataUsingEncoding:NSUTF8StringEncoding];
            retVal = [UTFEncodedSourceValue encryptWithKey:@TTTENCRYPTIONKEY];
        }
        return retVal;
    }

    - (id)reverseTransformedValue:(id)transformedValue{
        id retVal=nil;
        if (transformedValue != nil){
            NSData *data = [transformedValue decryptWithKey:@TTTENCRYPTIONKEY];
            retVal = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];

        }
        return retVal;
    }

@end
